-- Author: This mod was made by Norbert Thien, multimediamobil – Region Süd (mmmsued), 2024
-- Code: Except otherwise specified, all code in this project is licensed as LGPLv3.
-- Media: Except otherwise specified, all media and any other content in this project which is not source code is licensed as CC BY SA 3.0. 

local modname = minetest.get_current_modname()
local S = minetest.get_translator(modname)

-- invisible light block for ceilings and walls
minetest.register_node("licht:hidden_lightblock", {
	description = S("Hidden Light Block"),
	tiles = {"licht_hidden_lightblock.png"},
	inventory_image = "licht_hidden_lightblock_inv.png",
	use_texture_alpha = "clip",
	drawtype = "nodebox",
	node_box =  {
		type = "fixed",
		fixed = { -0.5, -0.5, -0.5, 0.5, -0.45, 0.5 }
	},
	sunlight_propagates = true,
	light_source = 14,
	paramtype = "light",
	paramtype2 = "facedir",
	walkable = false,
	groups = {
		snappy = 3
	},
	sounds = default.node_sound_glass_defaults(),
	on_place = minetest.rotate_node
})