-- Author: This mod was made by Norbert Thien, multimediamobil – Region Süd (mmmsued), 2024
-- Code: Except otherwise specified, all code in this project is licensed as LGPLv3.
-- Media: Except otherwise specified, all media and any other content in this project which is not source code is licensed as CC BY SA 3.0. 
-- Note: This mode uses concepts and code from the mod »mesecons« and textures from the mod »default« (»minetest_game«)


-- Töne für verschiedene Materialien
local soundsConfig = function (pMaterial)
	if string.find(pMaterial, "Snow") then
		return default.node_sound_snow_defaults()
	elseif string.find(pMaterial, "Grass") then
		return default.node_sound_leaves_defaults()
	elseif string.find(pMaterial, "Dirt") then
		return default.node_sound_dirt_defaults()
	elseif string.find(pMaterial, "Ice") then
		return default.node_sound_glass_defaults()
	elseif string.find(pMaterial, "Wood") then
		return default.node_sound_wood_defaults()
	elseif string.find(pMaterial, "Default") then --Default Sand
		return default.node_sound_sand_defaults()
	else
		return default.node_sound_stone_defaults()
	end
end

-- Materialien für verschiedene Blöcke
local tilesConfig = function (pName)
	if string.find(pName, "grass") then
		return {"blockwires_grass.png", "blockwires_dirt.png", {name = "blockwires_dirt.png^blockwires_grass_side.png", tileable_vertical = false}}
	elseif string.find(pName, "snow") then
		return {"blockwires_snow.png", "blockwires_dirt.png", {name = "blockwires_dirt.png^blockwires_snow_side.png", tileable_vertical = false}}
	else
		return {"blockwires_" .. pName .. ".png"} -- Standardblöcke mit 6 gleichen Materialseiten
	end
end

-- Materialien im Ordner textures: erster Eintrag Datei(teil)name, zweiter Eintrag description
local blockwires = {
		{"acaciawood", "Acacia Wood"},
		{"aspenwood", "Aspen Wood"},
		{"brickstone", "Brick Stone"},
		{"desertsandstonebrick", "Desert Sandstonebrick"},
		{"desertstonebrick", "Desert Stonebrick"},
		{"dirt", "Dirt"},
		{"grass", "Grass"},
		{"ice", "Ice"},
		{"junglewood", "Jungle Wood"},
		{"pinewood", "Pine Wood"},
		{"sand", "Default Sand"},
		{"sandstone", "Sandstone"},
		{"sandstonebrick", "Sandstonebrick"},
		{"silversandstonebrick", "Silver Sandstonebrick"},
		{"snow", "Snow"},
		{"stonebrick", "Stonebrick"},
		{"stone", "Stone"},
		{"wood", "wood"},
}

-- Schleife, in der die Blöcke zusammengebaut werden
for _, row in ipairs(blockwires) do

	local name = row[1]
	local description = row[2]

minetest.register_node("mesecons_blockwires:wire_" .. name .. "_off", {
	description = "Wire " .. description .. " Block",
	tiles = tilesConfig(name),
	inventory_image = "blockwires_" .. name .. ".png^blockwires_mese.png",
	drop = "mesecons_blockwires:wire_" .. name .. "_off",
	--selection_box = selectionbox,
	groups = {cracky = 3, oddly_breakable_by_hand = 3},
	sounds = soundsConfig(description),
	mesecons = {conductor = {
		state = mesecon.state.off,
		onstate = "mesecons_blockwires:wire_" .. name .. "_on",
		rules = mesecon.rules.alldirs
	}},
	on_blast = mesecon.on_blastnode,
})


minetest.register_node("mesecons_blockwires:wire_" .. name .. "_on", {
	description = "Wire " .. description .. " Block",
	tiles = tilesConfig(name),
	drop = "mesecons_blockwires:wire_" .. name .. "_on",
	--selection_box = selectionbox,
	groups = {cracky = 3, oddly_breakable_by_hand = 3, not_in_creative_inventory = 1},
	sounds = soundsConfig(description),
	mesecons = {conductor = {
		state = mesecon.state.on,
		offstate = "mesecons_blockwires:wire_" .. name .. "_off",
		rules = mesecon.rules.alldirs
	}},
	on_blast = mesecon.on_blastnode,
})
end


local name = "glass"
local description = "Glass"

-- Glas-Material off
minetest.register_node("mesecons_blockwires:wire_" .. name .. "_off", {
	description = "Wire " .. description .. " Block",
	drawtype = "glasslike_framed_optional",
	tiles = {"blockwires_" .. name .. ".png"},
	inventory_image = "blockwires_" .. name .. ".png^blockwires_mese.png",
	paramtype = "light",
	paramtype2 = "glasslikeliquidlevel",
	sunlight_propagates = true,
	is_ground_content = false,
	groups = {cracky = 3, oddly_breakable_by_hand = 3},
	sounds = soundsConfig(description),
	mesecons = {conductor = {
		state = mesecon.state.off,
		onstate = "mesecons_blockwires:wire_" .. name .. "_on",
		rules = mesecon.rules.alldirs
	}},
	on_blast = mesecon.on_blastnode,
})

-- Glas-Material on
minetest.register_node("mesecons_blockwires:wire_" .. name .. "_on", {
	description = "Wire " .. description .. " Block",
	drawtype = "glasslike_framed_optional",
	tiles = {"blockwires_" .. name .. ".png"},
	inventory_image = "blockwires_" .. name .. ".png^blockwires_mese.png",
	paramtype = "light",
	paramtype2 = "glasslikeliquidlevel",
	sunlight_propagates = true,
	is_ground_content = false,
	groups = {cracky = 3, oddly_breakable_by_hand = 3, not_in_creative_inventory = 1},
	sounds = soundsConfig(description),
	mesecons = {conductor = {
		state = mesecon.state.on,
		offstate = "mesecons_blockwires:wire_" .. name .. "_off",
		rules = mesecon.rules.alldirs
	}},
	on_blast = mesecon.on_blastnode,
})


local name = "leaves"
local description = "Bush Leaves"

-- Buschblätter off
minetest.register_node("mesecons_blockwires:wire_" .. name .. "_off", {
	description = "Wire " .. description .. " Block",
	drawtype = "allfaces_optional",
	waving = 1,
	tiles = {"blockwires_" .. name .. ".png"},
	inventory_image = "blockwires_" .. name .. ".png^blockwires_mese.png",
	paramtype = "light",
	groups = {cracky = 3, oddly_breakable_by_hand = 3, snappy = 3, flammable = 2, leaves = 1},
	sounds = default.node_sound_leaves_defaults(),
	mesecons = {conductor = {
		state = mesecon.state.off,
		onstate = "mesecons_blockwires:wire_" .. name .. "_on",
		rules = mesecon.rules.alldirs
	}},
	on_blast = mesecon.on_blastnode,
})

-- Buschblätter on
minetest.register_node("mesecons_blockwires:wire_" .. name .. "_on", {
	description = "Wire " .. description .. " Block",
	drawtype = "allfaces_optional",
	waving = 1,
	tiles = {"blockwires_" .. name .. ".png"},
	inventory_image = "blockwires_" .. name .. ".png^blockwires_mese.png",
	paramtype = "light",
	groups = {cracky = 3, oddly_breakable_by_hand = 3, snappy = 3, flammable = 2, leaves = 1, not_in_creative_inventory = 1},
	sounds = default.node_sound_leaves_defaults(),
	mesecons = {conductor = {
		state = mesecon.state.on,
		offstate = "mesecons_blockwires:wire_" .. name .. "_off",
		rules = mesecon.rules.alldirs
	}},
	on_blast = mesecon.on_blastnode,
})


-- Lava mit animierter Textur off
minetest.register_node("mesecons_blockwires:wire_lava_off", {
	description = "Wire Lava Block",
	drawtype = "nodebox",
	tiles = {
		{
			name = "default_lava_source_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 3.0,
			},
		},
		{
			name = "default_lava_flowing_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 3.0,
			},
		},
	},
	inventory_image = "default_lava.png^blockwires_mese.png",
	paramtype = "light",
	light_source=minetest.LIGHT_MAX - 1,
	groups = {dig_immediate=2},
	mesecons = {conductor = {
		state = mesecon.state.off,
		onstate = "mesecons_blockwires:wire_lava_on",
		rules = mesecon.rules.alldirs
	}},
	on_blast = mesecon.on_blastnode,
})

-- Lava mit animierter Textur on
minetest.register_node("mesecons_blockwires:wire_lava_on", {
	description = "Wire Lava Block",
	drawtype = "nodebox",
	tiles = {
		{
			name = "default_lava_source_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 3.0,
			},
		},
		{
			name = "default_lava_flowing_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 3.0,
			},
		},
	},
	inventory_image = "default_lava.png^blockwires_mese.png",
	paramtype = "light",
	light_source=minetest.LIGHT_MAX - 1,
	groups = {dig_immediate=2, not_in_creative_inventory = 1},
	mesecons = {conductor = {
		state = mesecon.state.on,
		offstate = "mesecons_blockwires:wire_lava_off",
		rules = mesecon.rules.alldirs
	}},
	on_blast = mesecon.on_blastnode,
})


-- Wasser mit animierter Textur off
minetest.register_node("mesecons_blockwires:wire_water_off", {
	description = "Wire Water Block",
	drawtype = "nodebox",
	tiles = {
		{
			name = "blockwires_water.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0, -- bei mir 3.0
			},
		},
		{
			name = "blockwires_water.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	inventory_image = "default_water.png^blockwires_mese.png",
	paramtype = "light",
	groups = {dig_immediate=2},
	sounds = default.node_sound_water_defaults(),
	mesecons = {conductor = {
		state = mesecon.state.off,
		onstate = "mesecons_blockwires:wire_water_on",
		rules = mesecon.rules.alldirs
	}},
	on_blast = mesecon.on_blastnode,
})

-- Wasser mit animierter Textur on
minetest.register_node("mesecons_blockwires:wire_water_on", {
	description = "Wire Water Block",
	drawtype = "nodebox",
	tiles = {
		{
			name = "blockwires_water.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0, -- bei mir 3.0
			},
		},
		{
			name = "blockwires_water.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	inventory_image = "default_water.png^blockwires_mese.png",
	paramtype = "light",
	groups = {dig_immediate=2, not_in_creative_inventory = 1},
	sounds = default.node_sound_water_defaults(),
	mesecons = {conductor = {
		state = mesecon.state.on,
		offstate = "mesecons_blockwires:wire_water_off",
		rules = mesecon.rules.alldirs
	}},
	on_blast = mesecon.on_blastnode,
})


-- keine Rezeptur für die Blöcke angelegt ... 
